
            //
            //
            // region POSTS SECONDARY VIEW
            //
            //

            const postsSecondaryViewConfigKey = "posts.secondary_view";
            let currentPostsSecondaryView = "comments";

            let renderPostsSecondaryView = () => {
                const secondaryView = document.getElementById('posts-secondary-view');
                if (!secondaryView) return;

                switch(currentPostsSecondaryView) {
                    case "comments": {
                        (async () => {
                            lib.showLoading();
                            secondaryView.innerHTML = `<h3>Loading Comments...</h3>`;

                            // Collect all post skool_ids and load their comments
                            const postIds = allPosts.map(p => p.skool_id);
                            let allComments = [];

                            // Load comments in batches to avoid overwhelming the server
                            const batchSize = 20;
                            const pagePosts = allPosts.slice(0, 100); // Limit to first 100 posts for comments
                            for (let i = 0; i < pagePosts.length; i += batchSize) {
                                const batch = pagePosts.slice(i, i + batchSize);
                                const promises = batch.map(p => get(`/api/post/${p.skool_id}/comments`));
                                const results = await Promise.all(promises);
                                for (const r of results) {
                                    if (r.ok && Array.isArray(r.data)) {
                                        allComments.push(...r.data);
                                    }
                                }
                            }

                            // Sort by date descending
                            allComments.sort((a, b) => {
                                const da = a.skool_created_at || '';
                                const db = b.skool_created_at || '';
                                return db.localeCompare(da);
                            });

                            let html = `<h3>Comments (${allComments.length})</h3>`;
                            html += `<small>From ${Math.min(pagePosts.length, allPosts.length)} posts</small><br><br>`;

                            for (const c of allComments.slice(0, 200)) {
                                const meta = c.metadata ? JSON.parse(c.metadata) : {};
                                const content = meta.content || '';
                                const preview = content.length > 150 ? content.substring(0, 150) + '...' : content;
                                const createdAt = c.skool_created_at ? new Date(c.skool_created_at).toLocaleDateString() : '-';
                                html += `<div style="margin: 4px 0; padding: 6px 8px; border-left: 2px solid #aaa;">
                                    <small><b>${c.user_name || '-'}</b> | ${createdAt}</small><br>
                                    <small>${preview}</small>
                                </div>`;
                            }
                            if (allComments.length > 200) {
                                html += `<small style="color:#888">Showing first 200 of ${allComments.length} comments</small>`;
                            }
                            if (allComments.length === 0) {
                                html += `<small style="color:#999">No comments found</small>`;
                            }

                            secondaryView.innerHTML = html;
                            lib.hideLoading();
                        })();
                    } break;

                    case "authors": {
                        // Unique authors from filtered posts
                        const authorMap = new Map();
                        for (const p of allPosts) {
                            const id = p.user_id || '';
                            if (!id) continue;
                            if (!authorMap.has(id)) {
                                authorMap.set(id, { name: p.user_name || '-', count: 0, upvotes: 0 });
                            }
                            const a = authorMap.get(id);
                            a.count++;
                            a.upvotes += (p.upvotes || 0);
                        }

                        // Sort by post count descending
                        const authors = [...authorMap.entries()].sort((a, b) => b[1].count - a[1].count);

                        let html = `<h3>Authors (${authors.length})</h3>`;
                        html += `<small>Unique authors of ${allPosts.length} posts</small><br><br>`;

                        for (const [userId, data] of authors) {
                            html += `<article style="margin: 4px 0; padding: 6px 8px; border-left: 3px solid var(--theme-color, #4a90d9);">
                                <b>${data.name}</b><br>
                                <small>${data.count} posts | ${data.upvotes} total upvotes</small>
                            </article>`;
                        }
                        if (authors.length === 0) {
                            html += `<small style="color:#999">No authors found</small>`;
                        }
                        secondaryView.innerHTML = html;
                    } break;

                    case "activity": {
                        (async () => {
                            lib.showLoading();
                            secondaryView.innerHTML = `<h3>Loading Activity...</h3>`;

                            const cutoffVal = await ConfigEntry.get('activity_cutoff_days');
                            const cutoffDays = parseInt(cutoffVal) || 90;

                            const communityRes = await get(`/api/activity/community?days=${cutoffDays}`);

                            let html = `<div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:8px;">
                                <h3 style="margin:0;">Post Activity</h3>
                                <span style="display:flex;align-items:center;gap:6px;font-size:0.85em;color:#9ca3af;">
                                    Last <input id="postsActivityCutoffDays" type="number" min="7" max="365" value="${cutoffDays}"
                                    style="width:60px;text-align:center;padding:2px 4px;font-size:0.9em;"
                                    onchange="updatePostsActivityCutoff(this.value)"> days
                                </span>
                            </div>`;

                            if (communityRes.ok) {
                                const cd = communityRes.data;
                                html += `
                                    <canvas id="posts-activity-chart" style="max-height: 250px"></canvas>
                                    <small>Total: ${cd.posts.reduce((a,b)=>a+b,0)} posts, ${cd.comments.reduce((a,b)=>a+b,0)} comments</small>
                                `;
                            }

                            secondaryView.innerHTML = html;
                            lib.hideLoading();

                            if (communityRes.ok) {
                                const cd = communityRes.data;
                                const canvas = document.getElementById('posts-activity-chart');
                                if (canvas) {
                                    new Chart(canvas.getContext('2d'), {
                                        type: 'line',
                                        data: {
                                            labels: cd.days.map(d => d.slice(5)),
                                            datasets: [
                                                { label: 'Posts', data: cd.posts, borderColor: '#3498db', tension: 0.3, pointRadius: 0 },
                                                { label: 'Comments', data: cd.comments, borderColor: '#e74c3c', tension: 0.3, pointRadius: 0 }
                                            ]
                                        },
                                        options: { responsive: true, maintainAspectRatio: true }
                                    });
                                }
                            }
                        })();
                    } break;

                    default:
                        secondaryView.innerText = "";
                        break;
                }
            };

            let setCurrentPostsSecondaryView = (view) => {
                currentPostsSecondaryView = view;
                ConfigEntry.set(postsSecondaryViewConfigKey, view).then();
                renderPostsSecondaryView();
            };

            let getCurrentPostsSecondaryView = async () => {
                const view = await ConfigEntry.get(postsSecondaryViewConfigKey);
                if (view) currentPostsSecondaryView = view;
            };

            let updatePostsActivityCutoff = async (val) => {
                const days = parseInt(val) || 90;
                await ConfigEntry.set('activity_cutoff_days', String(days));
                renderPostsSecondaryView();
            };
