class ChatContextDoc extends Entity {
    static _name = 'chatcontextdoc';
    static _defaults = {
        title: '',
        content: '',
        community_slug: '',
        sort_order: 0,
        is_builtin: false,
        description: ''
    };

    // Use the custom route (sets community_slug server-side) instead of generic CRUD
    get _endpoint() { return '/api/chat-context-docs'; }

    static async listDocs() {
        const res = await get('/api/chat-context-docs');
        return res.ok ? res.data.map(d => new this(d)) : [];
    }
}
