
            //
            //
            // region 2.VIEW
            //
            //

            // --- Local filter state for secondary views ---
            // dateFrom/dateTo use days-ago values (1=today, 1825=5yrs ago), same as main filter
            let postsLocalFilter = { dateFrom: 1, dateTo: 1825, commentsMin: 0, commentsMax: 1000, likesMin: 0, likesMax: 1000 };
            let communitiesLocalFilter = { sharedMin: 10 };
            let cachedPostsData = [];
            let cachedCommunitiesData = [];

            // --- Posts date slider handlers (reuses daysSliderSteps/daysToStepIndex/formatDaysDisplay from members.html) ---
            let handlePostsDateSliderInput = (side, stepIdx) => {
                const days = daysSliderSteps[stepIdx];
                const el = document.getElementById(`posts_date_${side}_label`);
                if (el) el.value = formatDaysDisplay(days);
            };

            let handlePostsDateSliderChange = (side, stepIdx) => {
                const days = daysSliderSteps[stepIdx];
                if (side === 'from') {
                    postsLocalFilter.dateFrom = days;
                    if (postsLocalFilter.dateTo < days) postsLocalFilter.dateTo = days;
                } else {
                    postsLocalFilter.dateTo = days;
                    if (postsLocalFilter.dateFrom > days) postsLocalFilter.dateFrom = days;
                }
                syncPostsDateSliderUI();
                renderPostsList();
            };

            let handlePostsDateInput = (side, isoValue) => {
                if (!isoValue) return;
                const days = isoStringToDays(isoValue);
                if (days < 1) return;
                const clamped = Math.min(1825, days);
                if (side === 'from') {
                    postsLocalFilter.dateFrom = clamped;
                    if (postsLocalFilter.dateTo < clamped) postsLocalFilter.dateTo = clamped;
                } else {
                    postsLocalFilter.dateTo = clamped;
                    if (postsLocalFilter.dateFrom > clamped) postsLocalFilter.dateFrom = clamped;
                }
                syncPostsDateSliderUI();
                renderPostsList();
            };

            let syncPostsDateSliderUI = () => {
                const fromSlider = document.getElementById('posts_date_from_slider');
                const toSlider = document.getElementById('posts_date_to_slider');
                if (fromSlider) fromSlider.value = daysToStepIndex(postsLocalFilter.dateFrom);
                if (toSlider) toSlider.value = daysToStepIndex(postsLocalFilter.dateTo);
                const fromLabel = document.getElementById('posts_date_from_label');
                const toLabel = document.getElementById('posts_date_to_label');
                if (fromLabel) fromLabel.value = formatDaysDisplay(postsLocalFilter.dateFrom);
                if (toLabel) toLabel.value = formatDaysDisplay(postsLocalFilter.dateTo);
            };

            // --- Posts count slider handlers ---
            let handlePostsSliderInput = (field, side, stepIdx) => {
                const count = countSliderSteps[stepIdx];
                const el = document.getElementById(`posts_${field}_${side}_label`);
                if (el) el.textContent = count;
            };

            let handlePostsSliderChange = (field, side, stepIdx) => {
                const count = countSliderSteps[stepIdx];
                const minKey = field + 'Min';
                const maxKey = field + 'Max';
                if (side === 'from') {
                    postsLocalFilter[minKey] = count;
                    if (postsLocalFilter[maxKey] < count) postsLocalFilter[maxKey] = count;
                } else {
                    postsLocalFilter[maxKey] = count;
                    if (postsLocalFilter[minKey] > count) postsLocalFilter[minKey] = count;
                }
                syncPostsSliderUI(field);
                renderPostsList();
            };

            let syncPostsSliderUI = (field) => {
                const minKey = field + 'Min';
                const maxKey = field + 'Max';
                const fromSlider = document.getElementById(`posts_${field}_from_slider`);
                const toSlider = document.getElementById(`posts_${field}_to_slider`);
                if (fromSlider) fromSlider.value = countToStepIndex(postsLocalFilter[minKey]);
                if (toSlider) toSlider.value = countToStepIndex(postsLocalFilter[maxKey]);
                const fromLabel = document.getElementById(`posts_${field}_from_label`);
                const toLabel = document.getElementById(`posts_${field}_to_label`);
                if (fromLabel) fromLabel.textContent = postsLocalFilter[minKey];
                if (toLabel) toLabel.textContent = postsLocalFilter[maxKey];
            };

            // --- Communities min shared members handler ---
            let handleCommMinSharedChange = (value) => {
                communitiesLocalFilter.sharedMin = parseInt(value) || 0;
                renderCommunitiesList();
            };

            // Build a local dual-thumb count slider HTML
            let buildLocalCountSlider = (prefix, field, fromVal, toVal) => {
                const maxIdx = countSliderSteps.length - 1;
                const fromIdx = countToStepIndex(fromVal);
                const toIdx = countToStepIndex(toVal);
                return `
                    <div class="dual-range-labels" style="padding:0; margin:0;">
                        <span class="dual-range-input" id="${prefix}_${field}_from_label">${fromVal}</span>
                        <span class="dual-range-unit"></span>
                        <span class="dual-range-input" id="${prefix}_${field}_to_label">${toVal}</span>
                    </div>
                    <div class="dual-range-track">
                        <input type="range" id="${prefix}_${field}_from_slider"
                            min="0" max="${maxIdx}" value="${fromIdx}"
                            oninput="handle${prefix === 'posts' ? 'Posts' : 'Comm'}SliderInput(${prefix === 'posts' ? "'" + field + "'," : ''}'from',this.value)"
                            onchange="handle${prefix === 'posts' ? 'Posts' : 'Comm'}SliderChange(${prefix === 'posts' ? "'" + field + "'," : ''}'from',this.value)">
                        <input type="range" id="${prefix}_${field}_to_slider"
                            min="0" max="${maxIdx}" value="${toIdx}"
                            oninput="handle${prefix === 'posts' ? 'Posts' : 'Comm'}SliderInput(${prefix === 'posts' ? "'" + field + "'," : ''}'to',this.value)"
                            onchange="handle${prefix === 'posts' ? 'Posts' : 'Comm'}SliderChange(${prefix === 'posts' ? "'" + field + "'," : ''}'to',this.value)">
                    </div>`;
            };

            // Build filter bar HTML for posts view
            let buildPostsFilterBar = () => {
                const daysMaxIdx = daysSliderSteps.length - 1;
                const dateFromIdx = daysToStepIndex(postsLocalFilter.dateFrom);
                const dateToIdx = daysToStepIndex(postsLocalFilter.dateTo);
                const dateFromDisplay = formatDaysDisplay(postsLocalFilter.dateFrom);
                const dateToDisplay = formatDaysDisplay(postsLocalFilter.dateTo);
                return `<div style="display:flex; gap:10px; flex-wrap:wrap; margin-bottom:8px; align-items:flex-start; font-size:0.85em; padding:8px 16px 8px 8px; border:1px solid #444; border-radius:4px;">
                    <div style="display:flex; flex-direction:column; gap:2px; min-width:180px; flex:2;">
                        <span>Date</span>
                        <div class="dual-range-labels" style="padding:0; margin:0;">
                            <input type="date" class="dual-range-date-input" id="posts_date_from_label"
                                value="${dateFromDisplay}" min="${oldestISO}" max="${todayISO}"
                                onchange="handlePostsDateInput('from',this.value); this.blur();">
                            <span class="dual-range-unit">&mdash;</span>
                            <input type="date" class="dual-range-date-input" id="posts_date_to_label"
                                value="${dateToDisplay}" min="${oldestISO}" max="${todayISO}"
                                onchange="handlePostsDateInput('to',this.value); this.blur();">
                        </div>
                        <div class="dual-range-track">
                            <input type="range" id="posts_date_from_slider"
                                min="0" max="${daysMaxIdx}" value="${dateFromIdx}"
                                oninput="handlePostsDateSliderInput('from',this.value)"
                                onchange="handlePostsDateSliderChange('from',this.value)">
                            <input type="range" id="posts_date_to_slider"
                                min="0" max="${daysMaxIdx}" value="${dateToIdx}"
                                oninput="handlePostsDateSliderInput('to',this.value)"
                                onchange="handlePostsDateSliderChange('to',this.value)">
                        </div>
                    </div>
                    <div style="display:flex; flex-direction:column; gap:2px; min-width:90px; flex:1;">
                        <span>Comments</span>
                        ${buildLocalCountSlider('posts', 'comments', postsLocalFilter.commentsMin, postsLocalFilter.commentsMax)}
                    </div>
                    <div style="display:flex; flex-direction:column; gap:2px; min-width:90px; flex:1;">
                        <span>Likes</span>
                        ${buildLocalCountSlider('posts', 'likes', postsLocalFilter.likesMin, postsLocalFilter.likesMax)}
                    </div>
                </div>
                <div id="posts-filtered-info" style="font-size:0.8em; color:#888; margin:4px 8px 6px 8px;"></div>
                <div id="posts-list-container"></div>`;
            };

            // Filter and render posts list from cache
            let renderPostsList = () => {
                let filtered = cachedPostsData;
                // Date filter: dateFrom=recent (small days-ago), dateTo=older (large days-ago)
                const newestDate = daysAgoToDate(postsLocalFilter.dateFrom);
                newestDate.setHours(23, 59, 59, 999);
                const oldestDate = daysAgoToDate(postsLocalFilter.dateTo);
                filtered = filtered.filter(p => {
                    if (!p.skool_created_at) return true;
                    const d = new Date(p.skool_created_at);
                    return d >= oldestDate && d <= newestDate;
                });
                filtered = filtered.filter(p => (p.comments || 0) >= postsLocalFilter.commentsMin);
                filtered = filtered.filter(p => (p.comments || 0) <= postsLocalFilter.commentsMax);
                filtered = filtered.filter(p => (p.upvotes || 0) >= postsLocalFilter.likesMin);
                filtered = filtered.filter(p => (p.upvotes || 0) <= postsLocalFilter.likesMax);

                const infoEl = document.getElementById('posts-filtered-info');
                if (infoEl) {
                    if (filtered.length !== cachedPostsData.length) {
                        infoEl.textContent = `Showing ${filtered.length} of ${cachedPostsData.length}`;
                    } else {
                        infoEl.textContent = '';
                    }
                }

                const container = document.getElementById('posts-list-container');
                if (!container) return;

                let html = '';
                for (const p of filtered) {
                    const meta = p.metadata ? JSON.parse(p.metadata) : {};
                    const title = meta.title || p.name || '(Untitled)';
                    const content = meta.content || '';
                    const preview = content.length > 100 ? content.substring(0, 100) + '...' : content;
                    const createdAt = p.skool_created_at ? new Date(p.skool_created_at).toLocaleDateString() : '-';
                    const commentCount = p.comments || 0;
                    html += `
                        <article style="margin: 4px 0; padding: 8px; border-left: 3px solid #3498db; cursor: pointer"
                            onclick="togglePostComments(this, '${p.skool_id}')">
                            <b>${title}</b><br>
                            <small style="color: #666">${preview}</small><br>
                            <small>
                                by <b>${p.user_name || '-'}</b> |
                                ${p.upvotes || 0} upvotes | ${commentCount} comments |
                                ${p.community_slug} | ${createdAt}
                            </small>
                            <div class="post-comments" style="display:none"></div>
                        </article>`;
                }
                if (filtered.length === 0) html = '<small style="color:#999">No posts match the current filter.</small>';
                container.innerHTML = html;
            };

            // Build filter bar HTML for communities view
            let buildCommunitiesFilterBar = () => {
                return `<div style="display:flex; gap:12px; flex-wrap:wrap; margin-bottom:8px; align-items:flex-start; font-size:0.85em; padding:8px 16px 8px 8px; border:1px solid #444; border-radius:4px;">
                    <div style="display:flex; flex-direction:column; gap:2px; min-width:130px;">
                        <span>Min Shared Members</span>
                        <input type="number" min="0" value="${communitiesLocalFilter.sharedMin}"
                            onchange="handleCommMinSharedChange(this.value)"
                            style="width:80px; background:#222; color:#ccc; border:1px solid #555; border-radius:4px; padding:4px 6px;">
                    </div>
                </div>
                <div id="communities-filtered-info" style="font-size:0.8em; color:#888; margin:4px 8px 6px 8px;"></div>
                <div id="communities-list-container" style="display: grid; grid-template-columns: 1fr 1fr; gap: 8px;"></div>`;
            };

            // Filter and render communities list from cache
            let renderCommunitiesList = () => {
                let filtered = cachedCommunitiesData;
                filtered = filtered.filter(c => (c.selection_count || 0) >= communitiesLocalFilter.sharedMin);

                const infoEl = document.getElementById('communities-filtered-info');
                if (infoEl) {
                    if (filtered.length !== cachedCommunitiesData.length) {
                        infoEl.textContent = `Showing ${filtered.length} of ${cachedCommunitiesData.length}`;
                    } else {
                        infoEl.textContent = '';
                    }
                }

                const container = document.getElementById('communities-list-container');
                if (!container) return;

                let html = '';
                for (const c of filtered) {
                    const name = c.name || c.slug;
                    const fetched = c.about_fetched ? '(details fetched)' : '';
                    html += `<article style="padding: 10px; border: 1px solid #444; border-left: 3px solid #27ae60; border-radius: 6px; cursor: pointer; overflow: hidden;"
                        onclick="changeCurrentCommunity('${c.slug}')">
                        <b style="display: block; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">${name}</b>
                        <small style="color: #888">${fetched}</small><br>
                        <small><b>${c.selection_count}</b> of selection | ${c.shared_user_count} global</small><br>
                        <small style="color: #888">slug: ${c.slug}</small>
                    </article>`;
                }
                if (filtered.length === 0) html = '<small style="color:#999">No communities match the current filter.</small>';
                container.innerHTML = html;
            };


            // secondary view selector
            const secondaryViewConfigKey = "members.secondary_view";
            let currentSecondaryView = "";
            let renderSecondaryView = () => {
                const secondaryView = document.getElementById('secondary-view');
                if (!secondaryView) return; // No secondary view in graph mode
                switch(currentSecondaryView){
                    case "posts": {
                        (async()=>{
                            lib.showLoading();
                            secondaryView.innerHTML = `<h3>Loading Posts...</h3>`;
                            const skoolIds = members.map(m => m.skool_id);
                            const res = await post('/api/post/by-users', { skool_ids: skoolIds });
                            cachedPostsData = res.ok ? res.data : [];
                            secondaryView.innerHTML = buildPostsFilterBar();
                            renderPostsList();
                            lib.hideLoading();
                        })();
                    } break;
                    case "communities": {
                        (async()=>{
                            lib.showLoading();
                            secondaryView.innerHTML = `<h3>Loading Communities...</h3>`;
                            const skoolIds = members.map(m => m.skool_id);
                            let data;
                            try {
                                const rawRes = await fetch('/api/communities/by-users', {
                                    method: 'POST',
                                    headers: { 'Content-Type': 'application/json' },
                                    body: JSON.stringify({ skool_ids: skoolIds })
                                });
                                lib.hideLoading();
                                if (!rawRes.ok) {
                                    lib.showSectionError('secondary-view', 'Communities', 'renderSecondaryView', 'communities-by-users');
                                    return;
                                }
                                data = await rawRes.json();
                            } catch (e) {
                                lib.hideLoading();
                                lib.showSectionError('secondary-view', 'Communities', 'renderSecondaryView', 'communities-by-users');
                                return;
                            }
                            if (data.parse_errors && data.parse_errors > 0) {
                                console.warn('[Communities by-users] parse_errors:', data.parse_errors, '— some community counts may be understated');
                            }
                            lib.retryCounters['communities-by-users'] = 0;
                            // Support both legacy plain-array and new {communities: [...], parse_errors: N} shape
                            cachedCommunitiesData = Array.isArray(data) ? data : (data.communities || data.items || []);
                            secondaryView.innerHTML = buildCommunitiesFilterBar();
                            renderCommunitiesList();
                        })();
                    } break;
                    case "export": {
                        secondaryView.innerHTML = `
                            <h3>Export (${members.length} Members)</h3>
                            <p><small>Exportiert die aktuelle Selektion als ZIP mit 3 CSV-Dateien: members.csv, posts.csv, comments.csv</small></p>
                            <button onclick="downloadMembersCsv()">Download ZIP</button>
                        `;
                    } break;
                    case "activity": {
                        (async()=>{
                            lib.showLoading();
                            secondaryView.innerHTML = `<h3>Loading Activity...</h3>`;
                            const skoolIds = members.map(m => m.skool_id);

                            // Load cutoff config (default 90 days)
                            const cutoffVal = await ConfigEntry.get('activity_cutoff_days');
                            const cutoffDays = parseInt(cutoffVal) || 90;

                            // Beide APIs parallel laden
                            const [communityRes, membersRes] = await Promise.all([
                                get(`/api/activity/community?days=${cutoffDays}`),
                                post('/api/activity/members', { skool_ids: skoolIds, days: cutoffDays })
                            ]);

                            // Heatmap render function
                            const renderHeatmap = (matrix, weekdays) => {
                                const maxVal = Math.max(...matrix.flat(), 1);
                                const hourLabels = ['12AM','','','3AM','','','6AM','','','9AM','','','12PM','','','3PM','','','6PM','','','9PM','','',''];
                                let html = '<div style="display:grid; grid-template-columns: 40px repeat(7, 1fr); gap:1px; font-size:10px">';
                                html += '<div></div>';
                                for (const day of weekdays) html += `<div style="text-align:center">${day}</div>`;
                                for (let h = 0; h < 24; h++) {
                                    html += `<div style="text-align:right; padding-right:3px">${hourLabels[h]}</div>`;
                                    for (let d = 0; d < 7; d++) {
                                        const val = matrix[d][h];
                                        const intensity = val / maxVal;
                                        const alpha = 0.1 + intensity * 0.9;
                                        const [r, g, b] = lib.primaryColorRGB;
                                        const bg = `rgba(${r}, ${g}, ${b}, ${alpha.toFixed(2)})`;
                                        html += `<div style="background:${bg}; height:10px; border-radius:1px" title="${weekdays[d]} ${h}:00 - ${val}"></div>`;
                                    }
                                }
                                html += '</div>';
                                return html;
                            };

                            let html = `<h3>Activity — Last ${cutoffDays} Days (${members.length} members)</h3>`;

                            // Heatmap
                            if (membersRes.ok) {
                                const md = membersRes.data;
                                html += `<small>When are members active? (Weekday x Hour)</small>`;
                                html += renderHeatmap(md.activity_matrix, md.weekdays);
                            }

                            // Line Chart
                            if (communityRes.ok) {
                                const cd = communityRes.data;
                                html += `
                                    <h4 style="margin-top:20px">Posts & Comments — Last ${cutoffDays} Days</h4>
                                    <canvas id="activity-chart" style="max-height: 200px"></canvas>
                                    <small>Total: ${cd.posts.reduce((a,b)=>a+b,0)} posts, ${cd.comments.reduce((a,b)=>a+b,0)} comments</small>
                                `;
                            }

                            secondaryView.innerHTML = html;
                            lib.hideLoading();

                            // Chart.js nach DOM-Update
                            if (communityRes.ok) {
                                const cd = communityRes.data;
                                const canvas = document.getElementById('activity-chart');
                                if (canvas) {
                                    new Chart(canvas.getContext('2d'), {
                                        type: 'line',
                                        data: {
                                            labels: cd.days.map(d => d.slice(5)),
                                            datasets: [
                                                { label: 'Posts', data: cd.posts, borderColor: '#3498db', tension: 0.3, pointRadius: 0 },
                                                { label: 'Comments', data: cd.comments, borderColor: '#e74c3c', tension: 0.3, pointRadius: 0 }
                                            ]
                                        },
                                        options: { responsive: true, maintainAspectRatio: true }
                                    });
                                }
                            }
                        })();
                    } break;
                    default: // posible -> not a bug
                        secondaryView.innerText = "";
                        break;
                }
            };
            // Async version for initial loading (no animation, awaitable)
            let renderSecondaryViewAsync = async () => {
                const secondaryView = document.getElementById('secondary-view');
                if (!secondaryView) return;
                switch(currentSecondaryView){
                    case "posts": {
                        secondaryView.innerHTML = `<h3>Loading Posts...</h3>`;
                        const skoolIds = members.map(m => m.skool_id);
                        const res = await post('/api/post/by-users', { skool_ids: skoolIds });
                        cachedPostsData = res.ok ? res.data : [];
                        secondaryView.innerHTML = buildPostsFilterBar();
                        renderPostsList();
                    } break;
                    case "communities": {
                        secondaryView.innerHTML = `<h3>Loading Communities...</h3>`;
                        const skoolIds = members.map(m => m.skool_id);
                        let data;
                        try {
                            const rawRes = await fetch('/api/communities/by-users', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/json' },
                                body: JSON.stringify({ skool_ids: skoolIds })
                            });
                            if (!rawRes.ok) {
                                lib.showSectionError('secondary-view', 'Communities', 'renderSecondaryView', 'communities-by-users');
                                return;
                            }
                            data = await rawRes.json();
                        } catch (e) {
                            lib.showSectionError('secondary-view', 'Communities', 'renderSecondaryView', 'communities-by-users');
                            return;
                        }
                        if (data.parse_errors && data.parse_errors > 0) {
                            console.warn('[Communities by-users] parse_errors:', data.parse_errors, '— some community counts may be understated');
                        }
                        lib.retryCounters['communities-by-users'] = 0;
                        cachedCommunitiesData = Array.isArray(data) ? data : (data.communities || data.items || []);
                        secondaryView.innerHTML = buildCommunitiesFilterBar();
                        renderCommunitiesList();
                    } break;
                    case "export": {
                        secondaryView.innerHTML = `<h3>Export (${members.length} Members)</h3>
                            <p><small>Exportiert die aktuelle Selektion als CSV-Datei.</small></p>
                            <button onclick="downloadMembersCsv()">Download CSV</button>`;
                    } break;
                    case "activity": {
                        secondaryView.innerHTML = `<h3>Loading Activity...</h3>`;
                        const skoolIds = members.map(m => m.skool_id);

                        // Load cutoff config (default 90 days)
                        const cutoffVal = await ConfigEntry.get('activity_cutoff_days');
                        const cutoffDays = parseInt(cutoffVal) || 90;

                        const [communityRes, membersRes] = await Promise.all([
                            get(`/api/activity/community?days=${cutoffDays}`),
                            post('/api/activity/members', { skool_ids: skoolIds, days: cutoffDays })
                        ]);
                        const renderHeatmap = (matrix, weekdays) => {
                            const maxVal = Math.max(...matrix.flat(), 1);
                            const hourLabels = ['12AM','','','3AM','','','6AM','','','9AM','','','12PM','','','3PM','','','6PM','','','9PM','','',''];
                            let html = '<div style="display:grid; grid-template-columns: 40px repeat(7, 1fr); gap:1px; font-size:10px">';
                            html += '<div></div>';
                            for (const day of weekdays) html += `<div style="text-align:center">${day}</div>`;
                            for (let h = 0; h < 24; h++) {
                                html += `<div style="text-align:right; padding-right:3px">${hourLabels[h]}</div>`;
                                for (let d = 0; d < 7; d++) {
                                    const val = matrix[d][h];
                                    const intensity = val / maxVal;
                                    const alpha = 0.1 + intensity * 0.9;
                                    const [r, g, b] = lib.primaryColorRGB;
                                    const bg = `rgba(${r}, ${g}, ${b}, ${alpha.toFixed(2)})`;
                                    html += `<div style="background:${bg}; height:10px; border-radius:1px" title="${weekdays[d]} ${h}:00 - ${val}"></div>`;
                                }
                            }
                            html += '</div>';
                            return html;
                        };
                        let html = `<h3>Activity — Last ${cutoffDays} Days (${members.length} members)</h3>`;
                        if (membersRes.ok) {
                            const md = membersRes.data;
                            html += `<small>When are members active? (Weekday x Hour)</small>`;
                            html += renderHeatmap(md.activity_matrix, md.weekdays);
                        }
                        if (communityRes.ok) {
                            const cd = communityRes.data;
                            html += `<h4 style="margin-top:20px">Posts & Comments — Last ${cutoffDays} Days</h4>
                                <canvas id="activity-chart" style="max-height: 200px"></canvas>
                                <small>Total: ${cd.posts.reduce((a,b)=>a+b,0)} posts, ${cd.comments.reduce((a,b)=>a+b,0)} comments</small>`;
                        }
                        secondaryView.innerHTML = html;
                        if (communityRes.ok) {
                            const cd = communityRes.data;
                            const canvas = document.getElementById('activity-chart');
                            if (canvas) {
                                new Chart(canvas.getContext('2d'), {
                                    type: 'line',
                                    data: {
                                        labels: cd.days.map(d => d.slice(5)),
                                        datasets: [
                                            { label: 'Posts', data: cd.posts, borderColor: '#3498db', tension: 0.3, pointRadius: 0 },
                                            { label: 'Comments', data: cd.comments, borderColor: '#e74c3c', tension: 0.3, pointRadius: 0 }
                                        ]
                                    },
                                    options: { responsive: true, maintainAspectRatio: true }
                                });
                            }
                        }
                    } break;
                }
            };

            let togglePostComments = async (articleEl, postSkoolId) => {
                const commentsDiv = articleEl.querySelector('.post-comments');
                if (!commentsDiv) return;

                // Toggle: if already visible, hide and return
                if (commentsDiv.style.display !== 'none') {
                    commentsDiv.style.display = 'none';
                    return;
                }

                // Show and load if not yet loaded
                commentsDiv.style.display = 'block';
                if (commentsDiv.dataset.loaded) return;

                commentsDiv.innerHTML = '<small>Loading comments...</small>';
                const res = await get(`/api/post/${postSkoolId}/comments`);
                const comments = res.ok ? res.data : [];
                commentsDiv.dataset.loaded = '1';

                if (comments.length === 0) {
                    commentsDiv.innerHTML = '<small style="color:#999">No comments</small>';
                    return;
                }

                let html = '';
                for (const c of comments) {
                    const meta = c.metadata ? JSON.parse(c.metadata) : {};
                    const content = meta.content || '';
                    const createdAt = c.skool_created_at ? new Date(c.skool_created_at).toLocaleDateString() : '-';
                    html += `<div style="margin: 4px 0 0 12px; padding: 4px 8px; border-left: 2px solid #aaa">
                        <small><b>${c.user_name || '-'}</b> | ${createdAt}</small><br>
                        <small>${content}</small>
                    </div>`;
                }
                commentsDiv.innerHTML = html;
            };

            let secondaryViewVisible = false;

            let setCurrentSecondaryView = async (view) => {
                if (view === currentSecondaryView && secondaryViewVisible) {
                    // Toggle off: clicking the already-active button hides the view
                    secondaryViewVisible = false;
                } else {
                    // Switch to new view or re-show
                    currentSecondaryView = view;
                    secondaryViewVisible = true;
                    ConfigEntry.set(secondaryViewConfigKey, view).then();
                }
                updateActionButtons();
                await renderMembersView();
                if (secondaryViewVisible) renderSecondaryView();
            };
            let actionButtonCounts = { posts: null, communities: null };

            let updateActionButtonCounts = async () => {
                // Posts count: sum from activityCounts for displayed members only
                let totalPosts = 0;
                for (const m of members) {
                    const c = activityCounts[m.skool_id];
                    if (c) totalPosts += (c.posts || 0);
                }
                actionButtonCounts.posts = totalPosts;

                // Communities count: lightweight fetch
                const skoolIds = members.map(m => m.skool_id);
                if (skoolIds.length > 0) {
                    const res = await post('/api/communities/by-users', { skool_ids: skoolIds });
                    if (res.ok) {
                        actionButtonCounts.communities = (res.data.communities || res.data).length || 0;
                    }
                } else {
                    actionButtonCounts.communities = 0;
                }

                updateActionButtons();
            };

            let updateActionButtons = () => {
                const buttons = document.querySelectorAll('#secondary-views button[data-action]');
                for (const btn of buttons) {
                    const action = btn.getAttribute('data-action');
                    if (action === currentSecondaryView && secondaryViewVisible) {
                        btn.style.border = '2px solid #d9534f';
                    } else {
                        btn.style.border = '';
                    }
                    // Show counts for posts and communities
                    const label = action.charAt(0).toUpperCase() + action.slice(1);
                    if (action === 'posts' && actionButtonCounts.posts !== null) {
                        btn.textContent = `${label} (${actionButtonCounts.posts})`;
                    } else if (action === 'communities' && actionButtonCounts.communities !== null) {
                        btn.textContent = `${label} (${actionButtonCounts.communities})`;
                    }
                }
            };

            let getCurrentSecondaryView = async () => {
                const view = await ConfigEntry.get(secondaryViewConfigKey);
                if (view) currentSecondaryView = view;
            }
