/**
 * AiChatSession - Frontend API wrapper for AI chat sessions
 * Does NOT extend Entity (custom routes, not generic CRUD)
 */
class AiChatSession {

    constructor(data) {
        Object.assign(this, data);
    }

    static async list(archived = 0) {
        const res = await fetch(`/api/chat/sessions?archived=${archived}`);
        const data = await res.json();
        return (data.sessions || []).map(s => new AiChatSession(s));
    }

    static async create(title) {
        const res = await fetch('/api/chat/sessions', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ title: title || undefined })
        });
        const data = await res.json();
        return new AiChatSession(data);
    }

    async update(fields) {
        const res = await fetch(`/api/chat/sessions/${this.id}`, {
            method: 'PUT',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(fields)
        });
        return res.json();
    }

    async remove() {
        const res = await fetch(`/api/chat/sessions/${this.id}`, {
            method: 'DELETE'
        });
        return res.json();
    }

    async loadMessages() {
        const res = await fetch(`/api/chat/sessions/${this.id}/messages`);
        const data = await res.json();
        return data.messages || [];
    }

    async importMessages(messages) {
        const res = await fetch(`/api/chat/sessions/${this.id}/import`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ messages })
        });
        return res.json();
    }
}
